//
//	BredPlugin.cpp
//


#include "BredPlugin.h"


BredPlugin::BredPlugin(BRect frame, const char* name, DBlock& databuf)
	: BWindow(frame, name, B_TITLED_WINDOW, 0L), buffer (databuf)
{
	buffer.Register (this);
}


BredPlugin::~BredPlugin()
{
	buffer.Unregister (this);
}


void
BredPlugin::DispatchMessage(BMessage* msg, BHandler *hndlr)
{
	Lock();

	switch (msg->what) {
	case msg_DataChanged:
		DataChanged();
		break;
		
	default:
		BWindow::DispatchMessage(msg, hndlr);
		break;
	}
	
	Unlock();
}
